/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.baseclasses;

import java.util.List;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableIncrement;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableSet;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableToggle;

public class ComputedVariable {
    public static final String INVERTED_PREFIX = "!";
    public static final String CONSTANT_PREFIX = "#";
    public final String variableKey;
    public AEntityD_Definable<?> entity;
    private ComputedVariableOperator function;
    private boolean changesOnPartialTicks;
    private boolean randomVariable;
    private boolean isConstant;
    private boolean shouldSaveToNBT;
    private boolean changed;
    public boolean shouldReset = true;
    private long lastTickChecked;
    public double currentValue;
    public boolean isActive;
    public final ComputedVariable invertedVariable;

    public ComputedVariable(AEntityD_Definable<?> entity, String variable, ComputedVariableOperator function, boolean changesOnPartialTicks) {
        this.function = function;
        this.variableKey = variable;
        this.entity = entity;
        this.changesOnPartialTicks = changesOnPartialTicks;
        this.randomVariable = variable.startsWith("random");
        this.isConstant = variable.startsWith(CONSTANT_PREFIX);
        this.invertedVariable = !variable.startsWith(INVERTED_PREFIX) ? (this.isConstant ? new ComputedVariable(entity, INVERTED_PREFIX + variable, null, changesOnPartialTicks) : new ComputedVariable(entity, INVERTED_PREFIX + variable, partialTicks -> this.computeInvertedValue(partialTicks), changesOnPartialTicks)) : null;
        if (this.isConstant) {
            this.setInternal(Double.valueOf(variable.substring(CONSTANT_PREFIX.length())), true);
        } else {
            this.setInternal(0.0, true);
        }
    }

    public ComputedVariable(AEntityD_Definable<?> entity, String variable, IWrapperNBT data) {
        this(entity, variable, null, false);
        if (data != null) {
            this.setInternal(data.getDouble(this.variableKey), true);
        }
        this.shouldSaveToNBT = true;
        this.shouldReset = false;
    }

    public ComputedVariable(AEntityD_Definable<?> entity, String variable) {
        this(entity, variable, null, false);
        this.shouldReset = false;
    }

    public ComputedVariable(boolean bool) {
        this(null, bool ? "#1" : "#0", null, false);
    }

    public String toString() {
        return this.variableKey + ":" + this.currentValue;
    }

    public static boolean isNumberedVariable(String variable) {
        return variable.matches("^.*_\\d+$");
    }

    public static int getVariableNumber(String variable) {
        return Integer.parseInt(variable.substring(variable.lastIndexOf(95) + 1)) - 1;
    }

    private final boolean setInternal(double value, boolean bypassChangeChecks) {
        if (this.currentValue != value || bypassChangeChecks) {
            this.currentValue = value;
            this.isActive = this.currentValue > 0.0;
            this.changed = true;
            if (this.invertedVariable != null) {
                this.invertedVariable.currentValue = this.currentValue > 0.0 ? 0.0 : 1.0;
                boolean bl = this.invertedVariable.isActive = !this.isActive;
            }
            if (!bypassChangeChecks) {
                this.changed = true;
            }
            return true;
        }
        return false;
    }

    public final void setFunctionTo(ComputedVariable other) {
        this.entity = other.entity;
        this.function = other.function;
        this.isConstant = other.isConstant;
        this.changesOnPartialTicks = other.changesOnPartialTicks;
        this.randomVariable = other.randomVariable;
        this.setInternal(other.currentValue, true);
    }

    public final double getValue() {
        return this.computeValue(0.0f);
    }

    public final double computeValue(float partialTicks) {
        if (this.function != null) {
            if (this.randomVariable || this.changesOnPartialTicks && partialTicks != 0.0f) {
                this.setInternal(this.function.apply(partialTicks), false);
            } else if (this.lastTickChecked != this.entity.ticksExisted) {
                this.setInternal(this.function.apply(partialTicks), false);
                this.lastTickChecked = this.entity.ticksExisted;
            }
        }
        return this.currentValue;
    }

    private final double computeInvertedValue(float partialTicks) {
        this.computeValue(partialTicks);
        return this.invertedVariable.currentValue;
    }

    public final void setTo(double value, boolean sendPacket) {
        if (!this.isConstant && this.setInternal(value, false) && sendPacket) {
            InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableSet(this, this.currentValue));
        }
    }

    public final void setActive(boolean active, boolean sendPacket) {
        this.setTo(active ? 1.0 : 0.0, sendPacket);
    }

    public final void adjustBy(double value, boolean sendPacket) {
        if (!this.isConstant && this.setInternal(this.currentValue + value, false) && sendPacket) {
            InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableIncrement(this, value));
        }
    }

    public final void toggle(boolean sendPacket) {
        if (!this.isConstant && this.setInternal(this.currentValue + this.currentValue > 0.0 ? 0.0 : 1.0, false) && sendPacket) {
            InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableToggle(this));
        }
    }

    public final boolean increment(double incrementValue, double minValue, double maxValue, boolean sendPacket) {
        if (!this.isConstant) {
            double newValue = this.currentValue + incrementValue;
            if (minValue != 0.0 || maxValue != 0.0) {
                if (newValue < minValue) {
                    newValue = minValue;
                } else if (newValue > maxValue) {
                    newValue = maxValue;
                }
            }
            if ((newValue = (double)Math.round(newValue * 1000.0) / 1000.0) != this.currentValue) {
                incrementValue = newValue - this.currentValue;
                if (this.setInternal(newValue, false) && sendPacket) {
                    InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableIncrement(this, incrementValue, minValue, maxValue));
                }
                return true;
            }
        }
        return false;
    }

    public boolean hasChanged() {
        if (this.changed) {
            this.changed = false;
            return true;
        }
        return false;
    }

    public final void saveToNBT(List<String> savedNames, IWrapperNBT data) {
        if (this.shouldSaveToNBT && this.currentValue != 0.0) {
            data.setDouble(this.variableKey, this.currentValue);
            savedNames.add(this.variableKey);
        }
    }

    @FunctionalInterface
    public static interface ComputedVariableOperator {
        public double apply(float var1);
    }
}

